#ifndef TEXTEDITOR_H
#define TEXTEDITOR_H

#include <QWidget>
#include <QTextEdit>
#include <QVBoxLayout>

class TextEditor : public QWidget
{
    Q_OBJECT

public:
    explicit TextEditor(QWidget *parent = nullptr);

    bool loadFile(const QString &fileName);
    bool saveFile(const QString &fileName);
    QString currentFile() const { return m_fileName; }
    void setCurrentFile(const QString &fileName);

    QTextEdit *editor() const { return m_textEdit; }

private:
    QTextEdit *m_textEdit;
    QString m_fileName;
};

#endif // TEXTEDITOR_H
