#include "mainwindow.h"
#include <QMenuBar>
#include <QFileDialog>
#include <QMessageBox>
#include <QMdiSubWindow>
#include <QApplication>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), mdiArea(new QMdiArea(this))
{
    setCentralWidget(mdiArea);

    QMenu *fileMenu = menuBar()->addMenu("File");
    fileMenu->addAction("New", this, &MainWindow::newFile);
    fileMenu->addAction("Open", this, &MainWindow::openFile);
    fileMenu->addAction("Save", this, &MainWindow::saveFile);
    fileMenu->addAction("Save As", this, &MainWindow::saveFileAs);
     fileMenu->addAction("Exit", this, &MainWindow::Exit);

    QMenu *helpMenu = menuBar()->addMenu("Help");
    helpMenu->addAction("About", this, &MainWindow::showAbout);

    setWindowTitle("Notepad");
}

void MainWindow::newFile()
{
    auto editor = new TextEditor;
    mdiArea->addSubWindow(editor);
    editor->show();
}

void MainWindow::openFile()
{
    QString fileName = QFileDialog::getOpenFileName(this, "Open File");
    if (fileName.isEmpty())
        return;

    auto editor = new TextEditor;
    if (editor->loadFile(fileName)) {
        mdiArea->addSubWindow(editor);
        editor->show();
    } else {
        delete editor;
        QMessageBox::warning(this, "Error", "Could not open file");
    }
}

void MainWindow::saveFile()
{
    TextEditor *editor = activeEditor();
    if (!editor)
        return;

    if (editor->currentFile().isEmpty()) {
        saveFileAs();
        return;
    }

    if (!editor->saveFile(editor->currentFile()))
        QMessageBox::warning(this, "Error", "Could not save file");
}

void MainWindow::saveFileAs()
{
    TextEditor *editor = activeEditor();
    if (!editor)
        return;

    QString fileName = QFileDialog::getSaveFileName(this, "Save File As");
    if (fileName.isEmpty())
        return;

    if (!editor->saveFile(fileName))
        QMessageBox::warning(this, "Error", "Could not save file");
}

void MainWindow::Exit()
{
    QApplication::quit();
}

void MainWindow::showAbout()
{
    QMessageBox::about(this, "About Notepad",
                       "Notepad 2026\nCopyright Brian Ponnampalam\nCompiled Using Qt6");
}

TextEditor* MainWindow::activeEditor()
{
    if (QMdiSubWindow *sub = mdiArea->activeSubWindow())
        return qobject_cast<TextEditor*>(sub->widget());
    return nullptr;
}
