#ifndef PINGWIDGET_H
#define PINGWIDGET_H

#include <QWidget>
#include <QLineEdit>
#include <QPushButton>
#include <QTextEdit>
#include <QProcess>

class PingWidget : public QWidget {
    Q_OBJECT

public:
    PingWidget(QWidget *parent = nullptr);

private slots:
    void startPing();
    void readPingOutput();
    void handlePingFinished(int exitCode, QProcess::ExitStatus status);

private:
    QLineEdit *hostInput;
    QPushButton *pingButton;
    QTextEdit *outputArea;
    QProcess *pingProcess;
};

#endif // PINGWIDGET_H
