#include <SDL2/SDL.h>
#include <SDL2/SDL_mixer.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SONGS 100
#define MAX_PATH 512

int has_m3u_extension(const char *filename) {
    const char *dot = strrchr(filename, '.');
    return dot && strcmp(dot, ".m3u") == 0;
}

int has_mp3_extension(const char *filename) {
    const char *dot = strrchr(filename, '.');
    return dot && strcmp(dot, ".mp3") == 0;
}

int load_playlist(const char *filename, char songs[][MAX_PATH], int *count) {
    FILE *fp = fopen(filename, "r");
    if (!fp) {
        perror("Failed to open playlist");
        return 0;
    }

    char line[MAX_PATH];
    *count = 0;
    while (fgets(line, sizeof(line), fp) && *count < MAX_SONGS) {
        line[strcspn(line, "\r\n")] = 0; // Remove newline
        if (strlen(line) > 0) {
            strncpy(songs[*count], line, MAX_PATH);
            (*count)++;
        }
    }

    fclose(fp);
    return 1;
}

int i = 0;

int main(int argc, char *argv[]) {
    if (argc < 2) {
        printf("Copyright 2025, Brian Ponnampalam.\n");
        printf("Terminal MP3 Player\n\n");
        printf("Usage: %s filename.mp3 | playlist.m3u\n", argv[0]);
        return 1;
    }
    
    if (has_m3u_extension(argv[1])) {

    char songs[MAX_SONGS][MAX_PATH];
    int song_count = 0;

    if (!load_playlist(argv[1], songs, &song_count)) {
        return 1;
    }

    if (SDL_Init(SDL_INIT_AUDIO) < 0) {
        fprintf(stderr, "SDL_Init Error: %s\n", SDL_GetError());
        return 1;
    }

    if (Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, 2, 2048) < 0) {
        fprintf(stderr, "Mix_OpenAudio Error: %s\n", Mix_GetError());
        SDL_Quit();
        return 1;
    }

    for (int i = 0; i < song_count; ++i) {
        Mix_Music *music = Mix_LoadMUS(songs[i]);
        if (!music) {
            fprintf(stderr, "Failed to load %s: %s\n", songs[i], Mix_GetError());
        }

        printf("Playing: %s\n", songs[i]);
        Mix_PlayMusic(music, 1);
        while (Mix_PlayingMusic()) {
            SDL_Delay(100);
        }

        Mix_FreeMusic(music);
    }

    Mix_CloseAudio();
    SDL_Quit();
    return 0;
    }
    else if(has_mp3_extension(argv[1])){
    
        char songs[MAX_SONGS][MAX_PATH];
        int song_count = 0;

        if (!load_playlist(argv[1], songs, &song_count)) {
            return 1;
        }

        if (SDL_Init(SDL_INIT_AUDIO) < 0) {
            fprintf(stderr, "SDL_Init Error: %s\n", SDL_GetError());
            return 1;
        }

        if (Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, 2, 2048) < 0) {
            fprintf(stderr, "Mix_OpenAudio Error: %s\n", Mix_GetError());
            SDL_Quit();
            return 1;
        }

        Mix_Music *music = Mix_LoadMUS(argv[1]);
        if (!music) {
            fprintf(stderr, "Failed to load %s: %s\n", songs[i], Mix_GetError());
        }

        printf("Playing: %s\n", argv[1]);
        Mix_PlayMusic(music, 1);
        while (Mix_PlayingMusic()) {
            SDL_Delay(100);
        }

        Mix_FreeMusic(music);
        
        Mix_CloseAudio();
        SDL_Quit();
        return 0;

    }
}
